	subroutine origf(x,n,np,f,ndf1,ndf2,pvalue)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate Tsay's (1986) Original F test
c   statistic and its pvalue.
c
c   Input: x = a double precision vector of length n containing the
c              time series.
c          n = an integer containing the length of the time series.
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: f = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of 
c                  freedom of the test statistic.
c           ndf2 = an integer containing the denominator degrees of
c                  freedom of the test statistic.
c           pvalue = a double precision real scalar containing the
c                    p-value of the test statistic from an F(ndf1,ndf2)
c                    distribution.
c
c   Accuracy: implicit double precision (a-h,p-z)
c
c   Written: 7/27/97 Jane L. Harvill
c
c   Subprograms called: IMSL subroutine DRLSE, IMSL subroutine DGEMV,
c                       vech, IMSL subroutine DRGIVN, IMSL subroutine
c                       DGEMM, IMSL double precision function DFDF,
c                       IMSL double precision function DMACH.
c
c**********************************************************************
c
	parameter(nmx = 500, nkmx = 5,npmx = 10, nqmx = npmx*(npmx+1)/2)
c
	implicit double precision (a - h, p - z)
c
	double precision x(nmx),y(nmx),xr(nmx,npmx)
	double precision xt(nkmx*npmx),xtt(1,npmx*nkmx)
	double precision beta(npmx),yfit(nmx),res1(nmx)
c
	double precision z(nmx,nqmx+npmx),zv((npmx*nkmx)**2)
	double precision b(nqmx,nqmx),r(npmx,npmx),d(npmx),sse2(nqmx,nqmx)
	double precision xmin(npmx),xmax(npmx),yfit2(nmx,nqmx)
	double precision res2(nmx,nqmx),beta2(nqmx)
c
	integer indind(npmx),inddep(nqmx)
c
c	external DRLSE, DGEMV, vech, DRGIVN, DGEMM, DFDF, DMACH
c
c   Initialize constants and matrices.
c     First major loop - y,yfit,res1,xr,z,res2
c     Second major loop - xt,xtt,beta,r,d,indind
c     Third major loop - zv,b,sse2,beta2,inddep
c
	ndf1 = 0
	ndf2 = 0
	pvalue = 0.0d0
	f = 0.0d0
	sse1 = 0.0d0
	sst = 0.0d0
c
c
c   Build matrix of "dependent" variables for first and second
c   regression.  The matrices to be built are described below.
c   xr = [X_{t-1},...,X_{t-p}] for t = p+1,...,N.
c   y is a vector containing the "effective observations"; that is
c   y = (X_{p+1},...,X_{n}).
c   xt is the ith row of xr and xtt is the transpose of xt.  These
c   are used in obtaining the half-stack vector z for each 
c   observation.
c
	ndf1 = np*(np+1)/2
	do i = 1,n-np
		y(i) = x(np+i)
		do j = 1,np
			xr(i,j) = x(np+i-j)
			z(i,j) = xr(i,j)
			xt(j) = xr(i,j)
			xtt(1,j) = xt(j)
		enddo
		call vech(xt,xtt,npmx,np,1,1,np,0,zv)
		do j = 1,ndf1
			z(i,j+np) = zv(j)
		enddo
	enddo
c
c   Calculate least squares regression estimates of the coefficients
c   of the autoregressive process of order np.
c
	call DRLSE(n-np,y,np,xr,nmx,0,beta,sst,sse1)
c
c   Calculate residuals from above regression.  These residuals will
c   be used as "dependent" variables in the third step of the test.
c
c   IMSL subroutine DGEMV multiplies a matrix times a vector and
c   assigns to yfit <- 1.0d0*y*beta + 0.0d0*yfit.
c
	call DGEMV('N',n-np,np,1.0d0,xr,nmx,beta,1,0.0d0,yfit,1)
c
c
c   Calculate residuals:
c
	do i = 1,n-np
		res1(i) = y(i) - yfit(i)
	enddo
c
c   Now run second regression by regressing the half-stacking vector
c   z on the data matrix xr.  Obtain residuals.  IMSL subroutines
c   DRGIVN and DGEMM are used in a similar manner for these
c   computations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of z that are the independent variables.  
c   indind is of length np.
c
c   inddep is a vector of indices required by DRGIVN.  inddep is of
c   length ndf1 containing the column numbers of z that are the
c   dependent variables.
c
	do i = 1,np
		indind(i) = i
	enddo
	do i = 1,ndf1
		inddep(i) = np + i
	enddo
c
	call DRGIVN(0,n-np,np+ndf1,z,nmx,0,np,indind,ndf1,inddep,0,0,0,
     +	100*dmach(4),b,nqmx,r,npmx,d,irank,dfe,sse2,nqmx,nrmiss,
     +	xmin,xmax)
c
c   DRGIVN will return the following:
c    b = np x ndf1 matrix containing least squares solution.
c    r = np x np upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = ndf1 x ndf1 matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np containing the maximum values 
c            for each of the regressors.     
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit2 <- 1.0d0*xr*b + 0.0d0*yfit2.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of xr and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of xr
c     np = number of rows of xr and number of columns of b.  
c     ndf1 = number of rows of b.
c     nmx = leading dimension of xr.
c     npmx = leading dimension of b.
c     nmx = leading dimension of yfit2.
c
	call DGEMM('N','N',n-np,ndf1,np,1.0d0,xr,nmx,b,nqmx,0.0d0,yfit2,
     +	nmx)
c
c   Calculate residual matrix:
c
	do i = 1,n-np
	do j = 1,ndf1
		res2(i,j) = z(i,np+j) - yfit2(i,j)
	enddo
	enddo
c
c   Perform third and final regression.  Regress residuals from the
c   first regression on the residuals from the second regression.	
c
c   Use DRLSE to perform calculations.
c
	call DRLSE(n-np,res1,ndf1,res2,nmx,0,beta2,sst,sse)
c
	ndf2 = n - np*(np+3)/2
c
	ssr = sst - sse
c
	f = (ssr/dble(ndf1))/(sse/dble(ndf2))
c
	pvalue = 1 - DFDF(f,dble(ndf1),dble(ndf2))
c
	return
	end	
